define([
    'backbone',
    'json!resourceDirectoryJson',
], function (Backbone, resourceDirectory) {
    'use strict';

    // model
    var Resource = Backbone.Model.extend({
        initialize: function () {
            if (this.has('title')) {
                this.id = this.get('title');
            } else if (this.get('rel') === 'self') {
                this.id = 'self';
                this.set('title', 'self');
            }
        },

        idAttribute: 'title',

        // eslint-disable-next-line consistent-return
        validate: function () {
            if (!this.get('title')) {
                return 'title is a required field';
            }
            if (!this.get('href')) {
                return 'href is a required field';
            }
        },
        // ex. for href: "patient/{assigning-authority}/{patient-id}",
        // given attributes: { 'assigning-authority': '', 'patient-id': '8' }
        // returns href with replaced {attribute-name}'s
        formatHref: function (attributes) {
            var attr = attributes || {};
            var href = this.get('href');

            return href.replace(/{(\w+(-\w+)*)}/g, function(match, attributeName) {
                return typeof attr[attributeName] !== 'undefined' ? attr[attributeName] : attributeName;
            });
        },
    });

    // collection
    return Backbone.Collection.extend({
        model: Resource,
        parse: function(response) {
            return response.links;
        },
        initialize: function() {
            this.set(resourceDirectory, {parse: true});
        },
    });
});
